function test_suite = testMtimes %#ok<STOUT>
initTestSuite;

function testZeros %#ok<*DEFNU>
x = polysym(0);
y = polysym(0);
z = x*y;
assertEqual(z.Value,'0');

function testOneZero
x = polysym(0);
y = polysym('y');
z = x*y;
assertEqual(z.Value,'0');

function testZeroMtimesReal
x = polysym(0);
y = polysym(pi);
z = x*y;
assertEqual(z.Value,'0');

function testRealMtimesChar
x = polysym('x');
y = polysym(5);
z = x*y;
assertEqual(z.Value,'x*5');

function testScalarMtimesVector
x = polysym('x');
y = polysym(1:3);
z = x*y;
assertEqual(z(1).Value,'x');
assertEqual(z(2).Value,'x*2');
assertEqual(z(3).Value,'x*3');

function testVectorMtimesScalar
x = polysym('x');
y = polysym(1:3);
z = y*x;
assertEqual(z(1).Value,'x');
assertEqual(z(2).Value,'2*x');
assertEqual(z(3).Value,'3*x');

function testRowVectorMtimesRowVector
x = polysym({'x','y'});
y = polysym({'u','w'});
f = @() x*y;
assertExceptionThrown(f,'polysym:mtimes:innerdim')

function testRowVectorMtimesColumnVector
x = polysym({'x','y'});
y = polysym({'u','w'});
z = x*y.';
assertEqual(z.Value,'x*u+y*w')

function testMtimesTimes
x = polysym('x');
y = polysym('4.*y');
z = x*y;
assertEqual(z.Value,'x*4.*y');

function testMtimesMtimes
x = polysym('x');
y = polysym('4*y');
z = x*y;
assertEqual(z.Value,'x*4*y');
